IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_PROD_EST_TRIB_CONF_GRP_LOTE_APLICAR]')
												 AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[P_EST_PROD_EST_TRIB_CONF_GRP_LOTE_APLICAR]
GO


CREATE PROCEDURE [dbo].[P_EST_PROD_EST_TRIB_CONF_GRP_LOTE_APLICAR](@FLAG_CONSULTAR	INT, 
																		@FLAG_REFAZ INT,	
																		@SQL_FILTRO NVARCHAR(MAX), 
																		@CD_CTR		NVARCHAR(500) = '')
AS
BEGIN
   SET NOCOUNT ON;
   
  IF OBJECT_ID('TEMPDB..#TBL_EST_PROD_TRIB_GRP') IS NOT NULL
		BEGIN
			DROP TABLE #TBL_EST_PROD_TRIB_GRP
		END

   CREATE TABLE  #TBL_EST_PROD_TRIB_GRP (CD_EMP            INT,
										 CD_PROD           INT,
										 CD_CTR            INT,
										 DS_PROD           VARCHAR(200),
										 NR_NCM            VARCHAR(50),
										 LISTA_PROD        INT,
										 LISTA_PROD_NAME   VARCHAR(50))

	
	Select CD_PROD, EST_PROD_EST_TRIB_CLASS_FISC_PRC_REGIAO_FISCAL.CD_CLASS_FISC, EST_PROD_EST_TRIB_CLASS_FISC_PRC_REGIAO_FISCAL.CD_REGIAO_FISCAL 
	INTO #PROCESSAR --drop table #PROCESSAR
	From  EST_PROD_EST_TRIB_CLASS_FISC_PRC_REGIAO_FISCAL  
	INNER JOIN EST_TRIB_CLASS_FISC      ON EST_TRIB_CLASS_FISC.CD_CLASS_FISC = EST_PROD_EST_TRIB_CLASS_FISC_PRC_REGIAO_FISCAL.CD_CLASS_FISC  
	INNER JOIN PRC_REGIAO_FISCAL      ON PRC_REGIAO_FISCAL.CD_REGIAO_FISCAL = EST_PROD_EST_TRIB_CLASS_FISC_PRC_REGIAO_FISCAL.CD_REGIAO_FISCAL  
	Where CD_EMP = 1 

	DECLARE @SQL_EXEC NVARCHAR(MAX)
	--DECLARE @SQL_FILTRO NVARCHAR(MAX) = 'EST_PROD.CD_EMP = 1 ORDER BY  EST_PROD.DS_PROD'
	/*COnsulta para identificar os grupos corretos*/

	SET @SQL_EXEC = N'
	INSERT INTO #TBL_EST_PROD_TRIB_GRP
	SELECT DISTINCT 
				   EST_TRIB_CONF_GRP.CD_EMP,
				   EST_PROD.CD_PROD,
				   EST_TRIB_CONF_GRP.CD_CTR,
				   EST_PROD.DS_PROD, EST_PROD.NR_NCM, EST_PROD.LISTA_PROD,
														  CASE WHEN EST_PROD.LISTA_PROD = 0 THEN  
																	   ''POSITIVA''
																WHEN EST_PROD.LISTA_PROD = 1 THEN  
																	   ''NEGATIVA''
														   WHEN EST_PROD.LISTA_PROD = 2 THEN  
																	   ''NEUTRA''
																ELSE
																''NAO USA LISTA''
														  END AS LISTA_PROD_NAME
			FROM EST_TRIB_CONF_GRP
				 INNER JOIN EST_TRIB_CONF_GRP_NCM ON EST_TRIB_CONF_GRP.CD_CTR = EST_TRIB_CONF_GRP_NCM.CD_CTR
				 INNER JOIN PRC_REGIAO_FISCAL REG ON EST_TRIB_CONF_GRP.CD_REGIAO_FISCAL = REG.CD_REGIAO_FISCAL
				 INNER JOIN EST_PROD ON DBO.F_LIMPA_ZERO_ESQUERDA(EST_TRIB_CONF_GRP_NCM.NR_NCM) = DBO.F_LIMPA_ZERO_ESQUERDA(EST_PROD.NR_NCM)
				 LEFT JOIN EST_PROD_EST_ARV_MERCADOLOGICA ON 
											  EST_PROD.CD_EMP = EST_PROD_EST_ARV_MERCADOLOGICA.CD_EMP AND
											  EST_PROD.CD_PROD = EST_PROD_EST_ARV_MERCADOLOGICA.CD_PROD
				 OUTER APPLY (SELECT TOP 1 1 AS EXISTE_FP
							  FROM EST_PROD_FARMACIA_POPULAR FP
							  WHERE FP.CD_PROD = EST_PROD.CD_PROD
							  AND FP.CD_EMP = EST_PROD.CD_EMP
							  AND ISNULL(EST_TRIB_CONF_GRP.FLAG_ISENCAO_ICMS_FARM_POPULAR,0) = 1) FP
				 WHERE EST_TRIB_CONF_GRP.CD_EMP = 1
				  AND EST_TRIB_CONF_GRP.FLAG_GRP_FORN = 0
				  AND EST_TRIB_CONF_GRP.CD_CLASS_FISC = EST_PROD.CD_CLASS_FISC
				  AND EST_TRIB_CONF_GRP.TP_LISTA = EST_PROD.LISTA_PROD
				  AND NOT EXISTS (SELECT 1 FROM #PROCESSAR P WHERE P.CD_PROD = EST_PROD.CD_PROD)
				  AND ISNULL(EST_TRIB_CONF_GRP.FLAG_ISENCAO_ICMS_FARM_POPULAR,0) = ISNULL(FP.EXISTE_FP,0)
				  AND ' + @SQL_FILTRO + ''

		  EXEC (@SQL_EXEC)

		  SET @SQL_EXEC = N'
			INSERT INTO #TBL_EST_PROD_TRIB_GRP
			SELECT DISTINCT 
					EST_TRIB_CONF_GRP.CD_EMP,
				   EST_PROD.CD_PROD,
				   EST_TRIB_CONF_GRP.CD_CTR,
				   EST_PROD.DS_PROD, EST_PROD.NR_NCM, EST_PROD.LISTA_PROD,
														  CASE WHEN EST_PROD.LISTA_PROD = 0 THEN  
																	   ''POSITIVA''
																WHEN EST_PROD.LISTA_PROD = 1 THEN  
																	   ''NEGATIVA''
														   WHEN EST_PROD.LISTA_PROD = 2 THEN  
																	   ''NEUTRA''
																ELSE
																''NAO USA LISTA''
														  END AS LISTA_PROD_NAME
		FROM EST_TRIB_CONF_GRP EST_TRIB_CONF_GRP
			 INNER JOIN EST_TRIB_CONF_GRP_NCM ON EST_TRIB_CONF_GRP.CD_CTR = EST_TRIB_CONF_GRP_NCM.CD_CTR
			 INNER JOIN PRC_REGIAO_FISCAL REG ON EST_TRIB_CONF_GRP.CD_REGIAO_FISCAL = REG.CD_REGIAO_FISCAL
			 INNER JOIN EST_PROD ON DBO.F_LIMPA_ZERO_ESQUERDA(EST_TRIB_CONF_GRP_NCM.NR_NCM) = DBO.F_LIMPA_ZERO_ESQUERDA(EST_PROD.NR_NCM)
			 LEFT JOIN EST_PROD_EST_ARV_MERCADOLOGICA ON 
											  EST_PROD.CD_EMP = EST_PROD_EST_ARV_MERCADOLOGICA.CD_EMP AND
											  EST_PROD.CD_PROD = EST_PROD_EST_ARV_MERCADOLOGICA.CD_PROD
			OUTER APPLY (SELECT TOP 1 1 AS EXISTE_FP
							  FROM EST_PROD_FARMACIA_POPULAR FP
							  WHERE FP.CD_PROD = EST_PROD.CD_PROD
							  AND FP.CD_EMP = EST_PROD.CD_EMP
							  AND ISNULL(EST_TRIB_CONF_GRP.FLAG_ISENCAO_ICMS_FARM_POPULAR,0) = 1) FP
		WHERE EST_TRIB_CONF_GRP.CD_EMP = 1
			  AND EST_TRIB_CONF_GRP.FLAG_GRP_FORN = 0
			  AND Cast(EST_TRIB_CONF_GRP.cd_class_fisc AS VARCHAR) + ''-''
				   + Cast(EST_TRIB_CONF_GRP.cd_regiao_fiscal AS VARCHAR) in (select distinct cast(CD_CLASS_FISC as varchar) + ''-''
																+ cast(CD_REGIAO_FISCAL as varchar) from #PROCESSAR p where p.cd_prod = est_prod.cd_prod)
			AND EST_TRIB_CONF_GRP.TP_LISTA = EST_PROD.LISTA_PROD
			AND EXISTS (SELECT 1 FROM #PROCESSAR P WHERE P.CD_PROD = EST_PROD.CD_PROD)
			AND ISNULL(EST_TRIB_CONF_GRP.FLAG_ISENCAO_ICMS_FARM_POPULAR,0) = ISNULL(FP.EXISTE_FP,0)
			AND ' + @SQL_FILTRO + ''

			EXEC (@SQL_EXEC)
-------------------------------------------------------------------------------------------------------       
		IF @FLAG_CONSULTAR = 1
		BEGIN
			SELECT DISTINCT 
					CD_EMP, 
					CD_PROD, 
					DS_PROD, 
					NR_NCM, 
					LISTA_PROD, 
					LISTA_PROD_NAME 
			FROM #TBL_EST_PROD_TRIB_GRP
			ORDER BY DS_PROD
			RETURN;
		END

		IF @FLAG_REFAZ = 1
		BEGIN
			IF @CD_CTR <> '' 
			BEGIN
				DELETE A 
				FROM 
					EST_PROD_EST_TRIB_CONF_GRP A
				WHERE A.CD_CTR  IN (SELECT ID FROM UFD_PRM_IN_STRING(@CD_CTR))
			END 
		END 
-------------------------------------------------------------------------------------------------------
		
							
		INSERT INTO EST_PROD_EST_TRIB_CONF_GRP(CD_EMP,  CD_PROD,  CD_CTR)
		SELECT DISTINCT 
              T.CD_EMP, 
              T.CD_PROD, 
              T.CD_CTR
		FROM 
			#TBL_EST_PROD_TRIB_GRP T
			LEFT JOIN EST_PROD_EST_TRIB_CONF_GRP GRP_PROD ON
				T.CD_EMP	= GRP_PROD.CD_EMP AND 
				T.CD_PROD	= GRP_PROD.CD_PROD AND 
				T.CD_CTR	= GRP_PROD.CD_CTR
		WHERE
			GRP_PROD.CD_EMP IS NULL;

-------------------------------------------------------------------------------------------------------
END

